#!/bin/sh

. ./_blfsset.sh

APPNAME=MySQL-python
VER=1.2.4b4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	mariadb python setuptools
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Building...
python setup.py build \
	1> $LOG/$TARGET.2_build.log 2>&1 || exit 1

Installing
porg -lp $TARGET "python setup.py install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

