#!/bin/sh

. ./_blfsset.sh

APPNAME=Mako
VER=1.0.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	beaker markupsafe
. $WRK/_checkOptions.sh  \
	funcsigs
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Installing
sed -i "s:mako-render:&3:g" setup.py
porg -lp $TARGET "\
python3 setup.py install --optimize=1" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

