#!/bin/sh

. ./_blfsset.sh

APPNAME=make-ca
VER=0.8
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Installing
install -vdm755 /etc/ssl/local
wget http://www.cacert.org/certs/root.crt
wget http://www.cacert.org/certs/class3.crt

porg -lp $TARGET "\
openssl x509 -in root.crt -text -fingerprint -setalias \"CAcert Class 1 root\" \
        -addtrust serverAuth -addtrust emailProtection -addtrust codeSigning \
        > /etc/ssl/local/CAcert_Class_1_root.pem" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
openssl x509 -in class3.crt -text -fingerprint -setalias \"CAcert Class 3 root\" \
        -addtrust serverAuth -addtrust emailProtection -addtrust codeSigning \
        > /etc/ssl/local/CAcert_Class_3_root.pem" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
make install" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
sed -e 's%= /etc/ssl;%= "/etc/ssl";%' \
    -e 's%= /usr;%= "/usr";%'         \
    -i /usr/bin/c_rehash              &&
/usr/sbin/make-ca -g

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

