#!/bin/sh

. ./_blfsset.sh

APPNAME=libxml2
VER=2.9.8
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	Python-2 icu valgrind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#sed \
#  -e /xmlInitializeCatalog/d \
#  -e 's/((ent->checked =.*&&/(((ent->checked == 0) ||\
#          ((ent->children == NULL) \&\& (ctxt->options \& XML_PARSE_NOENT))) \&\&/' \
#  -i parser.c

Patching
patch -Np1 -i $DLD/libxml2-$VER-python3_hack-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i '/_PyVerify_fd/,+1d' python/types.c

Configuring
./configure --prefix=/usr \
	--disable-static  \
	--with-history    \
	--with-python=/usr/bin/python3 \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

