#!/bin/sh

. ./_blfsset.sh

APPNAME=libpwquality
VER=1.2.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	cracklib
. $WRK/_checkOptions.sh  \
	Linux-PAM python-2
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
CONF_OPTIONS="--prefix=/usr \
            --sysconfdir=/etc \
            --with-securedir=/lib/security \
$([ ${OPTION_python2} -ne 1 ] && echo --disable-python-bindings) \
            --disable-static \
"
#echo $CONF_OPTIONS
./configure $CONF_OPTIONS \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

