#!/bin/sh

. ./_blfsset.sh

APPNAME=krb5
VER=1.13
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET \(Workaround\)

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	dejagnu keyutils openldap python-2 rpcbind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

#if [ ${OPTION_openldap} -eq "1" ]; then
#  export WITHLDAP="--with-ldap "
#else
#  export WITHLDAP=" "
#fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo \ \ Patching unofficial...
#patch -Np1 -i $WRK/patch/krb5-$VER-gcc47.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

#echo \ \ Patching ...
#patch -Np1 -i $DLD/krb5-$VER-python_version-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

#Patching
#patch -Np1 -i $DLD/mitkrb-1.12.1-db2_fix-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

cd src
sed -e "s@python2.5/Python.h@& python2.7/Python.h@g" \
    -e "s@-lpython2.5]@&,\n  AC_CHECK_LIB(python2.7,main,[PYTHON_LIB=-lpython2.7])@g" \
    -i configure.in
#sed -e "s@interp->result@Tcl_GetStringResult(interp)@g" \
#    -i kadmin/testing/util/tcl_kadm5.c
sed -e 's@\^u}@^u cols 300}@' \
    -i tests/dejagnu/config/default.exp

echo Autoconfing...
autoconf \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1

#./configure CPPFLAGS="-I/usr/include/et -I/usr/include/ss -DUSE_INTERP_RESULT" \
Configuring
./configure --prefix=/usr            \
            --sysconfdir=/etc        \
            --localstatedir=/var/lib \
            --with-system-et         \
            --with-system-ss         \
            --with-system-verto=no   \
            --enable-dns-for-realm   \
	$([ ${OPTION_openldap} -eq 1 ] && echo --with-ldap) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

for LIBRARY in gssapi_krb5 gssrpc k5crypto kadm5clnt kadm5srv \
               kdb5 kdb_ldap krad krb5 krb5support verto ; do
    chmod -v 755 /usr/lib/lib$LIBRARY.so \
	1>> $LOG/$TARGET.3_install.log 2>&1 || echo Error when chmod
done

porg -lp+ $TARGET "\
mv -v /usr/lib/libkrb5.so.3*        /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
mv -v /usr/lib/libk5crypto.so.3*    /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
mv -v /usr/lib/libkrb5support.so.0* /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -v -sf ../../lib/libkrb5.so.3.3        /usr/lib/libkrb5.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -v -sf ../../lib/libk5crypto.so.3.1    /usr/lib/libk5crypto.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -v -sf ../../lib/libkrb5support.so.0.1 /usr/lib/libkrb5support.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
mv -v /usr/bin/ksu /bin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
chmod -v 755 /bin/ksu \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#porg -lp+ $TARGET "\
#install -m644 -v ../doc/*.info /usr/share/info" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#for INFOFILE in admin install user; do
#    install-info --info-dir=/usr/share/info \
#                 /usr/share/info/krb5-$INFOFILE.info
#    rm ../doc/krb5-$INFOFILE.info
#done

install -v -dm755 /usr/share/doc/krb5-$VER \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
cp -vfr ../doc/* /usr/share/doc/krb5-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
unset LIBRARY

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

