#!/bin/sh

. ./_kdeset.sh

APPNAME=automoc4
VER=0.9.88
TARGET=$APPNAME-$VER
TARGETBALL=$KDEDLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	cmake qt-4
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Cmaking...
mkdir build
cd build
cmake -DCMAKE_INSTALL_PREFIX=$QTDIR .. \
	1> $LOG/$TARGET.1_cmake.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PacoingDone

