#!/bin/sh

. ./_blfsset.sh

APPNAME=junit
VER=4.10
TARGET=$APPNAME-$VER
TARGETDIR=${APPNAME}$VER

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir

echo  Extracting sources...
unzip $DLD/$TARGETDIR.zip 1>/dev/null 2>&1 || exit 1

TimeStart

cd $TARGETDIR

install -v -m755 -d /usr/share/{,doc/}junit-$VER 
chown -R root:root .

paco -p  $TARGET "\
cp -v -R junit* org  /usr/share/junit-$VER" \
	1> $LOG/$TARGET_1.copy.log 2>&1 || exit 1

paco -p+ $TARGET "\
cp -v -R *.html *doc /usr/share/doc/junit-$VER" \
	1>> $LOG/$TARGET_1.copy.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

