#!/bin/sh

. ./_blfsset.sh

APPNAME=inkscape
VER=0.92.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	freetype lcms2 cairomm glibmm gc pangomm \
	gtk+-2 gtkmm boost popt imagemagick
. $WRK/_checkOptions.sh  \
	poppler
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Patching unofficial...
patch -Np1 -i $WRK/inkscape-$VER.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

echo Autogen...
./autogen.sh \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1

Configuring
#IMAGEMAGICK_CFLAGS=-I/usr/include/ImageMagick-6 \
#IMAGEMAGICK_LIBS="-lMagickCore-6.Q16HDRI -lMagick++-6.Q16HDRI -lMagickWand-6.Q16HDRI" \
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make -j1 \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

