#!/bin/sh

. ./_blfsset.sh

APPNAME=gstreamer
APPVER=0
VER=0.10.36
VER2=0.10
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	glib-2 libxml2
. $WRK/_checkOptions.sh  \
	gobject-introspection gsl gtk-doc valgrind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo \ \ Patching \(unofficial\)...
#patch -Np1 -i $WRK/patch/gstreamer-0.10.30.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i  -e '/YYLEX_PARAM/d'                                       \
        -e '/parse-param.*scanner/i %lex-param { void *scanner }' \
            gst/parse/grammar.y

Configuring
./configure --prefix=/usr \
            --libexecdir=/usr/lib \
            --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/gstreamer-${VER2}/design
paco -p+ $TARGET "\
install -v -m644 docs/design/*.txt \
                    /usr/share/doc/gstreamer-${VER2}/design" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

if [ -d /usr/share/doc/gstreamer-${VER2}/faq/html ]; then
    chown -v -R root:root \
        /usr/share/doc/gstreamer-${VER2}/*/html
fi

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

