#!/bin/sh

. ./_blfsset.sh

APPNAME=graphite2
VER=1.3.10
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tgz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	cmake
. $WRK/_checkOptions.sh  \
	freetype python-2 harfbuzz
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i '/cmptest/d' tests/CMakeLists.txt

mkdir build
cd build

echo Cmaking...
cmake -DCMAKE_INSTALL_PREFIX=/usr .. \
	1> $LOG/$TARGET.1_cmake.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

