#!/bin/sh

VER=3.4.1
TARGET=gnome-applets-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

LFS=/mnt/lfs
SRC=$LFS/sources/BLFS
DLD=$LFS/download/BLFS
LOG=$LFS/work/BLFS/log

mkdir -pv $LOG

cd $SRC

echo $TARGET

echo \ \ Removing directory...
rm -fr $TARGETDIR

echo \ \ Extracting...
if ! test -f $DLD/$TARGETBALL; then
  echo \ \ Tarball not found: $TARGETBALL && exit 1
else
  tar xf $DLD/$TARGETBALL
fi

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --libexecdir=/usr/lib/gnome-applets \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p $TARGET 'make install' \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

