#!/bin/sh

. ./_blfsset.sh

APPNAME=ghostscript
VER=9.21
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	freetype libjpeg-turbo libpng libtiff lcms2
. $WRK/_checkOptions.sh  \
	cairo cups fontconfig gtk+-3 libidn \
	libpaper
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

rm -rf freetype jpeg lcms2 libpng

echo \ \ Configuring...
./configure \
	--prefix=/usr \
	--enable-dynamic \
	--with-system-libtiff \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Making so...
make so \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo \ \ Installing so...
porg -lp+ $TARGET "make soinstall" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m644 base/*.h /usr/include/ghostscript" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -v -s ghostscript /usr/include/ps" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
cp -rf doc /usr/share/ghostscript/$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -sv ../ghostscript/$VER/doc /usr/share/doc/ghostscript-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
tar -xvf $DLD/ghostscript-fonts-std-8.11.tar.gz \
  -C /usr/share/ghostscript --no-same-owner"

porg -lp+ $TARGET "\
tar -xvf $DLD/gnu-gs-fonts-other-6.0.tar.gz \
  -C /usr/share/ghostscript --no-same-owner"

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

cd ..
RemoveSrcDir
PorgingDone
