#!/bin/sh

. ./_blfsset.sh

APPNAME=frei0r
VER=19-10-14
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME-snapshot-$VER.tar.gz
TARGETDIR=$APPNAME-snapshot-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	opencv
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Autogeninig...
./autogen.sh \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

