#!/bin/sh

. ./_blfsset.sh

APPNAME=faad2
VER=2.7
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/faad2-$VER-mp4ff-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i "s:AM_CONFIG_HEADER:AC_CONFIG_HEADERS:g" configure.in
sed -i "s:man_MANS:man1_MANS:g" frontend/Makefile.am

echo Autoconfing...
autoreconf -fi \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

