#!/bin/sh

. ./_blfsset.sh

APPNAME=cyrus-sasl
VER=2.1.26
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh openssl
. $WRK/_checkOptions.sh  \
	db Linux-PAM openldap krb5 openjdk \
        mysql postgresql sqlite krb4 dmalloc
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/cyrus-sasl-$VER-fixes-3.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

echo Autoreconfing...
autoreconf -fi \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1
pushd saslauthd > /dev/null
autoreconf -fi \
	1>> $LOG/$TARGET.0_auto.log 2>&1 || exit 1
popd > /dev/null

Configuring
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --enable-auth-sasldb \
            --with-dbpath=/var/lib/sasl/sasldb2 \
            --with-saslauthd=/var/run/saslauthd \
            CFLAGS=-fPIC \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_installl.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/cyrus-sasl-$VER \
	1>> $LOG/$TARGET.3_installl.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m644 doc/{*.{html,txt,fig},ONEWS,TODO} \
    saslauthd/LDAP_SASLAUTHD /usr/share/doc/cyrus-sasl-$VER" \
	1>> $LOG/$TARGET.3_installl.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -v -m700 -d /var/lib/sasl" \
	1>> $LOG/$TARGET.3_installl.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

