#!/bin/sh

VER=0.0.9
TARGET=cantarell-fonts-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

. ./_blfsset.sh

echo Check Required...
./_checkRequired.sh fontconfig pkg-config || exit 1
if test "$1" == "check"; then
  exit 0
fi

#echo Check Options...
#. ./_checkOptions.sh 

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo -n \ \ Pacoing:\   && paco $TARGET || echo none

echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

