#!/bin/sh

. ./_blfsset.sh

APPNAME=bundler
gem search -r bundler | grep "^bundler " > tmp.txt
VER=`sed -e 's/^bundler (\([0-9]*\.[0-9]*\.[0-9]*\)).*/\1/' tmp.txt`
rm -f tmp.txt

TARGET=$APPNAME-$VER

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkExit.sh "$1" || exit $?

TimeStart

Installing
porg -lp $TARGET "\
gem install bundler \
--no-ri --no-rdoc" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

PorgingDone

