#!/bin/sh

. ./_blfsset.sh

APPNAME=alsa-utils
VER=1.0.27.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	alsa-lib
. $WRK/_checkOptions.sh  \
	libsamplerate dialog xmlto
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#if [ ${OPTION_xmlto} -ne 1 ]; then
#  echo \ \ Patching...
#  patch -Np1 -i $DLD/alsa-utils-$VER-no_xmlto-1.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
#fi

Configuring
#./configure --without-systemdsystemunitdir \
./configure --disable-alsaconf --disable-xmlto \
	1> $LOG/$TARGET.1_conf.log 2>&1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

