#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=pangox-compat
VER=0.0.2
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	pango
. $WRK/_checkOptions.sh  \
	Xorg-lib-libX11
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

if [ ${OPTION_XorgliblibX11} -eq "1" ]; then
  export WITHX="--with-x "
else
  export WITHX="--without-x "
fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
	--sysconfdir=/etc \
	--disable-static  \
        $WITHX \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

