#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=pango
VER=1.42.3
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	fontconfig glib-2 fribidi harfbuzz \
	gobject-introspection
. $WRK/_checkOptions.sh \
	Xorg-lib-libX11 \
	gtk-doc libthai
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

mkdir build
cd    build

Configuring
meson --prefix=/usr --sysconfdir=/etc .. \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
ninja \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "ninja install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

