#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=fluxbox
VER=1.3.2
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

echo Check Required...
../_checkRequired.sh Xorg-lib-libX11 || exit 1

echo Check Options...
. ../_checkOptions.sh imlib2

echo -n Tarball $TARGETBALL" "
if [ -e $XORGDLD/$TARGETBALL ]; then
  echo  found
else
  echo  not found && exit 1
fi

if test "$1" == "check"; then
  exit 0
fi

#if [ ${OPTION_LinuxPAM} -eq "1" ]; then
#  export WITHPAM=""
#else
#  export WITHPAM="--without-pam "
#fi

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh $XORGDLD/$TARGETBALL

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr \
	--enable-imlib2 \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo `cat /etc/lfs-release`,$TARGET,$START,$END \
        >> $TME/$APPNAME.txt

echo -n \ \ Pacoing:\   && paco $TARGET || echo none
 
echo \ \ Removing directory...
cd .. && rm -fr $TARGETDIR

