#!/bin/sh

. ./_blfsset.sh

APPNAME=Module-Build
VER=0.4224
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Executing Build.PL...
perl Build.PL \
	1> $LOG/$TARGET.1_buildpl.log 2>&1 || exit 1

echo Building...
./Build \
	1> $LOG/$TARGET.2_build.log 2>&1 || exit 1

Installing
porg -lp $TARGET "./Build install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

