#!/bin/sh

CHAP=8
VER=0.10
TARGET=porg-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

. ./_lfsset.sh

DLD=$LFS/download/BLFS

echo $CHAP: $TARGET

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

echo \ \ Patching unofficial...
patch -Np1 -i $WRK/../BLFS/porg-$VER.local_rcfile.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

echo \ \ Configuring...
./configure --prefix=/usr --sysconfdir=/etc \
	--disable-grop \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
./porg/porg -lD "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
sed -i 's/^#\(EXCLUDE.*\)$/\1:`pwd`/' /etc/porgrc \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
