#!/bin/sh

CHAP=8
APPNAME=gettext
VER=0.20.2
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
./configure --prefix=/usr    \
            --disable-static \
            --docdir=/usr/share/doc/gettext-$VER \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make BISON_LOCALEDIR=/usr/share/locale \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
porg -lp $TARGET -E`pwd` "make install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1
chmod -v 0755 /usr/lib/preloadable_libintl.so \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1

TimeEnd chap8

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
