#!/bin/sh

CHAP=8
APPNAME=binutils
VER=2.34
TARGET=$APPNAME-$VER
TARGETBALL=${TARGET}.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

sed -i '/@\tincremental_copy/d' gold/testsuite/Makefile.in

echo \ \ Patching...
patch -Np1 -i $DLD/binutils-2.34-gcc10_gold_test_fix-1.patch \
	1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

mkdir build
cd    build

echo \ \ Configuring...
../configure --prefix=/usr       \
             --enable-gold       \
             --enable-ld=default \
             --enable-plugins    \
             --enable-shared     \
             --disable-werror    \
             --enable-64-bit-bfd \
             --with-system-zlib  \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make tooldir=/usr \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
porg -lp $TARGET "make tooldir=/usr install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap8

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ../..
rm -fr $TARGETDIR

echo \ \ Done.
