#!/bin/sh

CHAP=8

TARGET=chrootagain

LFS=/mnt/lfs
SRC=$LFS/sources/LFS
DLD=$LFS/download/LFS
WRK=$LFS/work/LFS
LOG=$LFS/work/LFS/log
ERR=$LFS/work/LFS/err
TME=$LFS/work/LFS/time

mkdir -pv $LOG $ERR $TME

mount -v --bind /dev $LFS/dev

mount -v --bind /dev/pts $LFS/dev/pts
mount -vt proc proc $LFS/proc
mount -vt sysfs sysfs $LFS/sys
mount -vt tmpfs tmpfs $LFS/run

if [ -h $LFS/dev/shm ]; then
  mkdir -pv $LFS/$(readlink $LFS/dev/shm)
fi

chroot "$LFS" /usr/bin/env -i   \
    HOME=/root                  \
    TERM="$TERM"                \
    PS1='(lfs chroot) \u:\w\$ ' \
    PATH=/bin:/usr/bin:/sbin:/usr/sbin \
    /bin/bash --login +h

