#!/bin/sh

CHAP=7
TARGET=strip2

. /mnt/lfs/mnt/lfs/work/LFScripts/LFS/_lfsset.sh

LOG=/mnt/lfs/mnt/lfs/work/LFScripts/LFS/log64
TME=/mnt/lfs/mnt/lfs/work/LFScripts/LFS/time64

echo $TARGET

START=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo \ \ Unmounting...
umount $LFS/dev{/pts,}
umount $LFS/{sys,proc,run}

echo \ \ Stripping...
strip --strip-debug $LFS/usr/lib/* \
	1> $LOG/$CHAP.$TARGET.1_strip.log 2>&1
strip --strip-unneeded $LFS/usr/{,s}bin/* \
	1>> $LOG/$CHAP.$TARGET.1_strip.log 2>&1
strip --strip-unneeded $LFS/tools/bin/* \
	1>> $LOG/$CHAP.$TARGET.1_strip.log 2>&1

echo \ \ Removing...
rm -rf $LFS/usr/share/{info,man,doc} \
	1> $LOG/$CHAP.$TARGET.2_remove.log 2>&1

END=`date +'%Y/%m/%d %H:%M:%S.%N'`

echo $CHAP, $TARGET, $START, $END \
	>> $TME/_lfstime.txt

echo \ \ Done.
