#!/bin/sh

CHAP=7
APPNAME=perl
VER=5.32.0
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Configuring...
sh Configure -des                                     \
             -Dprefix=/usr                            \
             -Dvendorprefix=/usr                      \
             -Dprivlib=/usr/share/perl5/core_perl     \
             -Darchlib=/usr/lib/perl5/5.32/core_perl  \
             -Dsitelib=/usr/share/perl5/site_perl     \
             -Dsitearch=/usr/lib/perl5/5.32/site_perl \
             -Dvendorlib=/usr/share/perl5/vendor_perl \
             -Dvendorarch=/usr/lib/perl5/5.32/vendor_perl \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make -j1 \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

TimeEnd chap7

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
