#!/bin/sh

CHAP=7
APPNAME=libstdc++
VER=10.1.0
TARGET=$APPNAME-$VER
TARGETBALL=gcc-$VER.tar.xz
TARGETDIR=gcc-$VER

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

ln -s gthr-posix.h libgcc/gthr-default.h

mkdir build
cd    build

echo \ \ Configuring...
../libstdc++-v3/configure           \
    CXXFLAGS="-g -O2 -D_GNU_SOURCE" \
    --prefix=/usr                   \
    --disable-multilib              \
    --disable-nls                   \
    --disable-libstdcxx-pch         \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

TimeEnd chap7

echo \ \ Removing directory...
cd ../..
rm -fr $TARGETDIR

echo \ \ Done.
