#!/bin/sh

CHAP=6
APPNAME=eudev
VER=3.2.9
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. ./_lfsset.sh

cd $SRC

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

sed -r -i 's|/usr(/bin/test)|\1|' test/udev-test.pl
sed -i '/keyboard_lookup_key/d' src/udev/udev-builtin-keyboard.c

cat > config.cache << "EOF"
HAVE_BLKID=1
BLKID_LIBS="-lblkid"
BLKID_CFLAGS="-I/tools/include"
EOF

echo \ \ Configuring...
./configure --prefix=/usr           \
            --bindir=/sbin          \
            --sbindir=/sbin         \
            --libdir=/usr/lib       \
            --sysconfdir=/etc       \
            --libexecdir=/lib       \
            --with-rootprefix=      \
            --with-rootlibdir=/lib  \
            --enable-manpages       \
            --disable-static        \
            --config-cache          \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
LIBRARY_PATH=/tools/lib make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
mkdir -p /lib/udev/rules.d
mkdir -p /etc/udev/rules.d

echo \ \ Installing...
porg -lp $TARGET "\
make LD_LIBRARY_PATH=/tools/lib install" \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
tar -xvf $DLD/udev-lfs-20140408.tar.bz2" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
make -f udev-lfs-20140408/Makefile.lfs install" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
LD_LIBRARY_PATH=/tools/lib udevadm hwdb --update" \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap6

echo -n \ \ Porging:\   && porg $TARGET || echo none

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
