#!/bin/sh

. ./_lfsset.sh

CHAP=5
APPNAME=linux
TARGET=linux-$LINUX_VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

echo \ \ Making mrproper...
make mrproper \
	1> $LOG/$CHAP.$TARGET.1_mrproper.log 2>&1 || exit 1

echo \ \ Installing...
make headers \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

find usr/include -name '.*' -delete &&
rm usr/include/Makefile             &&
cp -rv usr/include $LFS/usr \
	1> $LOG/$CHAP.$TARGET.4_copy.log 2>&1 || exit 1

TimeEnd chap5

echo \ \ Removing Directory...
cd .. && rm -fr $TARGETDIR

echo \ \ Done.
