#!/bin/sh

CHAP=5
APPNAME=bzip2
VER=1.0.8
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo \ \ Making...
make -f Makefile-libbz2_so \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
make clean \
	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1
make \
	1>> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make PREFIX=/tools install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
cp -v bzip2-shared /tools/bin/bzip2 \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
cp -av libbz2.so* /tools/lib \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1
ln -sv libbz2.so.1.0 /tools/lib/libbz2.so \
	1>> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap5

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
