#!/bin/sh

CHAP=5
APPNAME=binutils
APPVER=.1
VER=2.34
TARGET=$APPNAME-$VER
TARGETBALL=${TARGET}.tar.xz
TARGETDIR=$TARGET

. ./_lfsset.sh

unset MAKEFLAGS

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

mkdir build
cd    build

echo \ \ Configuring...
../configure --prefix=$LFS/tools        \
             --with-sysroot=$LFS        \
             --target=$LFS_TGT          \
             --disable-nls              \
             --disable-werror           \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd chap5

echo \ \ Removing directory...
cd ../..
rm -fr $TARGETDIR

echo \ \ Done.
