#!/bin/sh

CHAP=4
TARGET=creatingminlayout

echo $TARGET

LFS=/mnt/lfs

mkdir -pv $LFS/{usr,lib,var,etc,bin,sbin}
case $(uname -m) in
  x86_64) mkdir -pv $LFS/lib64 ;;
esac

groupadd lfs
useradd -s /bin/bash -g lfs -m -k /dev/null lfs

passwd lfs

chown -v lfs $LFS/{usr,lib,var,etc,bin,sbin,tools}
case $(uname -m) in
  x86_64) chown -v lfs $LFS/lib64 ;;
esac

