#/bin/sh

. ./_clfsset.sh
. ./_6clfsset.sh

APPNAME=vim
VER=7.4
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=vim74

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/vim-$VER-branch_update-7.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

cat > src/auto/config.cache << "EOF"
vim_cv_getcwd_broken=no
vim_cv_memmove_handles_overlap=yes
vim_cv_stat_ignores_slash=no
vim_cv_terminfo=yes
vim_cv_toupper_broken=no
vim_cv_tty_group=world
EOF

echo '#define SYS_VIMRC_FILE "/tools/etc/vimrc"' >> src/feature.h

echo Configuring...
./configure --build=${CLFS_HOST} --host=${CLFS_TARGET} \
    --prefix=/tools --enable-gui=no --disable-gtktest --disable-xim \
    --disable-gpm --without-x --disable-netbeans --with-tlib=ncurses \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sv vim /tools/bin/vi \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

cat > /tools/etc/vimrc << "EOF"
" Begin /tools/etc/vimrc

set nocompatible
set backspace=2
set ruler
syntax on

" End /tools/etc/vimrc
EOF

TimeEnd

cd ..
RemoveSrcDir

echo Done.

