#/bin/sh

. ./_clfsset.sh
. ./_6clfsset.sh

APPNAME=gcc
VER=4.8.3
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.bz2
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
rm -fr gcc-build

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

echo Patching...
patch -Np1 -i $DLD/gcc-$VER-branch_update-1.patch \
        1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/gcc-$VER-specs-1.patch \
        1>> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo -en '\n#undef STANDARD_STARTFILE_PREFIX_1\n#define STANDARD_STARTFILE_PREFIX_1 "/tools/lib/"\n' >> gcc/config/linux.h
echo -en '\n#undef STANDARD_STARTFILE_PREFIX_2\n#define STANDARD_STARTFILE_PREFIX_2 ""\n' >> gcc/config/linux.h

cp gcc/Makefile.in{,.orig}
sed 's@\./fixinc\.sh@-c true@' gcc/Makefile.in.orig > gcc/Makefile.in

mkdir ../gcc-build
cd ../gcc-build

echo Configuring...
../gcc-4.8.3/configure --prefix=/tools \
    --libdir=/tools/lib64 --build=${CLFS_HOST} --host=${CLFS_TARGET} \
    --target=${CLFS_TARGET} --with-local-prefix=/tools --disable-nls \
    --enable-languages=c,c++ --disable-libstdcxx-pch \
    --with-system-zlib --with-native-system-header-dir=/tools/include \
    --disable-libssp --enable-libstdcxx-time --enable-checking=release \
        1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

cp Makefile{,.orig}
sed "/^HOST_\(GMP\|ISL\|CLOOG\)\(LIBS\|INC\)/s:/tools:/cross-tools:g" \
    Makefile.orig > Makefile

echo Making...
make AS_FOR_TARGET="${AS}" \
    LD_FOR_TARGET="${LD}" \
        1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
        1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

cp ../gcc-4.8.3/include/libiberty.h /tools/include

TimeEnd

cd ..
RemoveSrcDir
rm -fr gcc-build

echo Done.

