#/bin/sh

. ./_clfsset.sh
. ./_6clfsset.sh

APPNAME=bash
VER=4.3
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

echo Patching...
patch -Np1 -i $DLD/bash-$VER-branch_update-5.patch \
        1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

cat > config.cache << "EOF"
ac_cv_func_mmap_fixed_mapped=yes
ac_cv_func_strcoll_works=yes
ac_cv_func_working_mktime=yes
bash_cv_func_sigsetjmp=present
bash_cv_getcwd_malloc=yes
bash_cv_job_control_missing=present
bash_cv_printf_a_format=yes
bash_cv_sys_named_pipes=present
bash_cv_ulimit_maxfds=yes
bash_cv_under_sys_siglist=yes
bash_cv_unusable_rtsigs=no
gt_cv_int_divbyzero_sigfpe=yes
EOF

echo Configuring...
./configure --prefix=/tools \
    --build=${CLFS_HOST} --host=${CLFS_TARGET} \
    --without-bash-malloc --cache-file=config.cache \
        1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
        1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

