#/bin/sh

. ./_clfsset.sh

APPNAME=procps-ng
VER=3.3.9
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc ${BUILD32}" ./configure --prefix=/usr --exec-prefix= \
    --libdir=/usr/lib --docdir=/usr/share/doc/procps-ng-3.3.9 \
    --disable-kill \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

mv -v /usr/bin/pidof /bin \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/lib/libprocps.so.* /lib \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv ../../lib/$(readlink /usr/lib/libprocps.so) /usr/lib/libprocps.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
