#/bin/sh

. ./_clfsset.sh

APPNAME=perl
VER=5.20.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

sed -i -e '/^BUILD_ZLIB/s/True/False/' \
       -e '/^INCLUDE/s,\./zlib-src,/usr/include,' \
       -e '/^LIB/s,\./zlib-src,/usr/lib64,' \
       cpan/Compress-Raw-Zlib/config.in

echo Patching...
patch -Np1 -i $DLD/perl-$VER-Configure_multilib-1.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo 'installstyle="lib64/perl5"' >> hints/linux.sh

echo Configuring...
./configure.gnu --prefix=/usr \
   -Dvendorprefix=/usr \
   -Dman1dir=/usr/share/man/man1 \
   -Dman3dir=/usr/share/man/man3 \
   -Dpager="/bin/less -isR" \
   -Dlibpth="/usr/local/lib64 /lib64 /usr/lib64" \
   -Dcc="gcc ${BUILD64}" \
   -Dusethreads -Duseshrplib \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
unset BUILD_ZLIB BUILD_BZIP2

mv -v /usr/bin/perl{,-64} \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/bin/perl5.20.0{,-64} \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

ln -sv multiarch_wrapper /usr/bin/perl \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sv multiarch_wrapper /usr/bin/perl5.20.0 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
