#/bin/sh

. ./_clfsset.sh

APPNAME=man-db
VER=2.6.7.1
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo Configuring...
PKG_CONFIG_PATH="${PKG_CONFIG_PATH64}" \
    CC="gcc ${BUILD64}" ./configure --prefix=/usr --libexecdir=/usr/lib64 \
    --docdir=/usr/share/doc/man-db-2.6.7.1 --sysconfdir=/etc \
    --libdir=/usr/lib64 --disable-setuid --with-browser=/usr/bin/lynx \
    --with-vgrind=/usr/bin/vgrind --with-grap=/usr/bin/grap \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

