#/bin/sh

. ./_clfsset.sh

APPNAME=gmp
VER=6.0.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${TARGET}a.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
CC="gcc -isystem /usr/include ${BUILD64}" \
CXX="g++ -isystem /usr/include ${BUILD64}" \
LDFLAGS="-Wl,-rpath-link,/usr/lib64:/lib64 ${BUILD64}" \
  ./configure --prefix=/usr \
    --libdir=/usr/lib64 --enable-cxx \
    --docdir=/usr/share/doc/gmp-6.0.0 \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1
make html \
	1>> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
make install-html \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

mv -v /usr/include/gmp{,-64}.h \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

cat > /usr/include/gmp.h << "EOF"
/* gmp.h - Stub Header  */
#ifndef __STUB__GMP_H__
#define __STUB__GMP_H__

#if defined(__x86_64__) || \
    defined(__sparc64__) || \
    defined(__arch64__) || \
    defined(__powerpc64__) || \
    defined (__s390x__)
# include "gmp-64.h"
#else
# include "gmp-32.h"
#endif

#endif /* __STUB__GMP_H__ */
EOF

TimeEnd

cd ..
RemoveSrcDir

echo Done.
