#/bin/sh

. ./_clfsset.sh

APPNAME=glibc
VER=2.19
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
rm -fr glibc-build

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

LINKER=$(readelf -l /tools/bin/bash | sed -n 's@.*interpret.*/tools\(.*\)]$@\1@p')
sed -i "s|libs -o|libs -L/usr/lib64 -Wl,-dynamic-linker=${LINKER} -o|" \
  scripts/test-installation.pl
unset LINKER

sed -i 's/\\$$(pwd)/`pwd`/' timezone/Makefile

mkdir -p ../glibc-build
cd ../glibc-build

echo "slibdir=/lib64" >> configparms

echo Configuring...
CC="gcc ${BUILD64}" CXX="g++ ${BUILD64}" \
    ../glibc-2.19/configure --prefix=/usr \
    --disable-profile --enable-kernel=2.6.32 \
    --libexecdir=/usr/lib64/glibc --libdir=/usr/lib64 \
    --enable-obsolete-rpc \
        1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1
#echo Testing...
#make -k check 2>&1 \
#        1> $LOG/$THISFILE.2_test.log 2>&1 || (echo Error occured in tests)

echo Installing...
make install \
        1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
rm -v /usr/include/rpcsvc/*.x \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
cp -v ../glibc-2.19/nscd/nscd.conf /etc/nscd.conf \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mkdir -pv /var/cache/nscd \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
install -v -Dm644 ../glibc-2.19/nscd/nscd.tmpfiles /usr/lib/tmpfiles.d/nscd.conf \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
install -v -Dm644 ../glibc-2.19/nscd/nscd.service /lib/systemd/system/nscd.service \
        1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

mkdir -pv /usr/lib/locale
localedef -i cs_CZ -f UTF-8 cs_CZ.UTF-8
localedef -i de_DE -f ISO-8859-1 de_DE
localedef -i de_DE@euro -f ISO-8859-15 de_DE@euro
localedef -i en_HK -f ISO-8859-1 en_HK
localedef -i en_PH -f ISO-8859-1 en_PH
localedef -i en_US -f ISO-8859-1 en_US
localedef -i es_MX -f ISO-8859-1 es_MX
localedef -i fa_IR -f UTF-8 fa_IR
localedef -i fr_FR -f ISO-8859-1 fr_FR
localedef -i fr_FR@euro -f ISO-8859-15 fr_FR@euro
localedef -i it_IT -f ISO-8859-1 it_IT
localedef -i ja_JP -f EUC-JP ja_JP
localedef -i ja_JP -f UTF-8 ja_JP.UTF-8

cat > /etc/nsswitch.conf << "EOF"
# Begin /etc/nsswitch.conf

passwd: files
group: files
shadow: files

hosts: files dns
networks: files

protocols: files
services: files
ethers: files
rpc: files

# End /etc/nsswitch.conf
EOF

tar -xf $DLD/tzdata2014d.tar.gz

ZONEINFO=/usr/share/zoneinfo
mkdir -pv $ZONEINFO/{posix,right}

for tz in etcetera southamerica northamerica europe africa antarctica  \
          asia australasia backward pacificnew \
          systemv; do
    zic -L /dev/null   -d $ZONEINFO       -y "sh yearistype.sh" ${tz}
    zic -L /dev/null   -d $ZONEINFO/posix -y "sh yearistype.sh" ${tz}
    zic -L leapseconds -d $ZONEINFO/right -y "sh yearistype.sh" ${tz}
done

cp -v zone.tab iso3166.tab $ZONEINFO
zic -d $ZONEINFO -p America/New_York
unset ZONEINFO

cp -v /usr/share/zoneinfo/Japan \
    /etc/localtime

cat > /etc/ld.so.conf << "EOF"
# Begin /etc/ld.so.conf

/usr/local/lib
/usr/local/lib64
/opt/lib
/opt/lib64

# End /etc/ld.so.conf
EOF

TimeEnd

cd ..
RemoveSrcDir
rm -fr glibc-build

echo Done.

