#/bin/sh

. ./_clfsset.sh

APPNAME=acl
VER=2.2.52
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.src.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

sed -i -e 's|/@pkg_name@|&-@pkg_version@|' include/builddefs.in
sed -i "s:| sed.*::g" test/{sbits-restore,cp,misc}.test

echo Configuring...
CC="gcc ${BUILD64}" ./configure \
    --prefix=/usr --libdir=/lib64 \
    --libexecdir=/usr/lib64 \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install install-dev install-lib \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sfv ../../lib64/$(readlink /lib64/libacl.so) /usr/lib64/libacl.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
rm -v /lib64/libacl.so \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
chmod 755 -v /lib64/libacl.so.1.1.0 \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

