#/bin/sh

. ./_cblfsset.sh

APPNAME=sqlite
VER=3.7.15.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${APPNAME}-autoconf-3071502.tar.gz
TARGETDIR=${APPNAME}-autoconf-3071502

echo $TARGET

checkRequired ""
checkOptions  \
	tcl
checkTarball
checkExit "$1" || exit $?

cd $SRC

BIT32
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
export USE_ARCH=32 &&
CC="gcc ${BUILD32}" ./configure --prefix=/usr --enable-threadsafe \
	1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p $TARGET "\
make install" \
	1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
unset USE_ARCH

TimeEnd
cd ..

BIT64
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Configuring...
export USE_ARCH=64 &&
CC="gcc ${BUILD64}" ./configure --prefix=/usr \
    --libdir=/usr/lib64 --enable-threadsafe \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
paco -p+ $TARGET "\
make install" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
unset USE_ARCH

TimeEnd
cd ..
RemoveSrcDir
PacoingDone

