#/bin/sh

. ./_cblfsset.sh

APPNAME=openssl
VER=1.0.1e
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

checkRequired ""
checkOptions  ""
checkTarball
checkExit "$1" || exit $?

cd $SRC

BIT32
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/openssl-$VER-fix_manpages-1.patch \
	1> $LOG/$TARGET.$BIT.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/openssl-$VER-32bit_x86_64-1.patch \
	1>> $LOG/$TARGET.$BIT.0_patch.log 2>&1 || exit 1

echo Configuring...
./Configure linux-x86_64-32 --openssldir=/etc/ssl --prefix=/usr shared \
	1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
USE_ARCH=32 make CC="gcc ${BUILD32}" PERL=/usr/bin/perl \
	1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
porg -lp $TARGET "\
USE_ARCH=32 make PERL=/usr/bin/perl MANDIR=/usr/share/man install" \
	1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..

exit 0

BIT64
RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/openssl-$VER-fix_manpages-1.patch \
	1> $LOG/$TARGET.$BIT.0_patch.log 2>&1 || exit 1

echo Configuring...
./Configure linux-x86_64 --openssldir=/etc/ssl --prefix=/usr shared \
        1> $LOG/$TARGET.$BIT.1_conf.log 2>&1 || exit 1

echo Making...
USE_ARCH=64 make CC="gcc ${BUILD64}" PERL=/usr/bin/perl LIBDIR=lib64 \
        1> $LOG/$TARGET.$BIT.2_make.log 2>&1 || exit 1

echo Installing...
porg -lp+ $TARGET "\
USE_ARCH=64 make PERL=/usr/bin/perl MANDIR=/usr/share/man LIBDIR=lib64 install" \
        1> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -sv ../../etc/ssl /usr/share" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
cp -v -r certs /etc/ssl" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -v -d -m755 /usr/share/doc/openssl-1.0.1e" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
cp -v -r doc/{HOWTO,README,*.{txt,html,gif}} \
    /usr/share/doc/openssl-1.0.1e" \
        1>> $LOG/$TARGET.$BIT.3_install.log 2>&1 || exit 1

TimeEnd
cd ..
RemoveSrcDir
PorgingDone

