#!/bin/sh

. ./_blfsset.sh

APPNAME=texlive
VER=20170520
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET-source.tar.xz
TARGETDIR=$TARGET-source

echo $TARGET

. $WRK/_checkRequired.sh \
	harfbuzz icu graphite2 \
	poppler freetype fontconfig libpng
. $WRK/_checkOptions.sh  \
	ghostscript t1lib libgd \
	Xorg-lib-libX11 \
	zziplib clisp lua teckit
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

INSTDIR=/opt/texlive/2016
. $WRK/_texlive-funcs.sh
TEXARCH=$(uname -m | sed -e 's/i.86/i386/' -e 's/$/-linux/')

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

mkdir -p texlive-build
cd       texlive-build

teckit
lua52
luajit
kpathsea
ptexenc
zziplib
web2c
dvipdfmx
dvipsk
texlive

ldconfig
make texlinks
#mkdir -pv /opt/texlive/2016/tlpkg/TeXLive
#install -v -m644 ../texk/tests/TeXLive/* /opt/texlive/2016/tlpkg/TeXLive

TimeEnd

cd ..
RemoveSrcDir
PorgingDone
