#!/bin/sh

. ./_blfsset.sh

APPNAME=texlive
VER=20160523b
VER2=20160523
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/texlive/$TARGET-source.tar.xz
TARGETDIR=$APPNAME-${VER2}-source

echo $TARGET

. $WRK/_checkRequired.sh \
	ghostscript \
	fontconfig graphite2 harfbuzz icu \
	libpaper libpng poppler
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

TEXARCH=$(uname -m | sed -e 's/i.86/i386/' -e 's/$/-linux/')

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/texlive/texlive-$VER-source-upstream_fixes-2.patch \
	1> $LOG/$TARGET-full.0_patch.log 2>&1 || exit 1

mkdir texlive-build
cd texlive-build

Configuring

../configure                                        \
    --prefix=/opt/texlive/2016                      \
    --bindir=/opt/texlive/2016/bin/$TEXARCH         \
    --datarootdir=/opt/texlive/2016                 \
    --includedir=/opt/texlive/2016/include          \
    --infodir=/opt/texlive/2016/texmf-dist/doc/info \
    --libdir=/opt/texlive/2016/lib                  \
    --mandir=/opt/texlive/2016/texmf-dist/doc/man   \
    --disable-native-texlive-build                  \
    --disable-static --enable-shared                \
    --with-system-cairo                             \
    --with-system-fontconfig                        \
    --with-system-freetype2                         \
    --with-system-gmp                               \
    --with-system-graphite2                         \
    --with-system-harfbuzz                          \
    --with-system-icu                               \
    --with-system-libgs                             \
    --with-system-libpaper                          \
    --with-system-libpng                            \
    --with-system-mpfr                              \
    --with-system-pixman                            \
    --with-system-poppler                           \
    --with-system-xpdf                              \
    --with-system-zlib                              \
    --without-x                                     \
    --with-banner-add=" - BLFS"                     \
	1> $LOG/$TARGET-full.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET-full.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install-strip" \
	1> $LOG/$TARGET-full.3_install.log 2>&1 || exit 1

ldconfig
porg -lp+ $TARGET "make texlinks" \
	1>> $LOG/$TARGET-full.3_install.log 2>&1 || exit 1

mkdir -pv /opt/texlive/2016/tlpkg/TeXLive/

porg -lp+ $TARGET "\
install -v -m644 ../texk/tests/TeXLive/* /opt/texlive/2016/tlpkg/TeXLive/" \
	1>> $LOG/$TARGET-full.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
tar -xf $DLD/texlive/texlive-20160523b-texmf.tar.xz -C /opt/texlive/2016 --strip-components=1" \
	1> $LOG/$TARGET-full.4_install.log 2>&1 || exit 1

pushd /opt/texlive/2016
patch -Np1 -i $DLD/texlive/texlive-20160523b-texmf-upstream_fixes-1.patch
popd

porg -lp+ $TARGET "\
mktexlsr" \
	1>> $LOG/$TARGET-full.4_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
fmtutil-sys --all" \
	1>> $LOG/$TARGET-full.4_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
mtxrun --generate" \
	1>> $LOG/$TARGET-full.4_install.log 2>&1 || exit 1

sed -i '/^mpost,/d' /opt/texlive/2016/texmf-dist/web2c/texmf.cnf

porg -lp+ $TARGET "\
fmtutil-sys --all" \
	1>> $LOG/$TARGET-full.4_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

