#!/bin/sh

. ./_blfsset.sh

APPNAME=spidermonkey
VER=1.0.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/js185-$VER.tar.gz
TARGETDIR=js-1.8.5

echo $TARGET

. $WRK/_checkRequired.sh nspr python-2 zip
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC

RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

cd js/src 
sed -i 's#s \($(SHLIB_\(ABI\|EXACT\)_VER)\)#s $(notdir \1)#' Makefile.in

Configuring
./configure --prefix=/usr --enable-threadsafe --with-system-nspr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../../..
pwd
RemoveSrcDir
PacoingDone

