#!/bin/sh

. ./_blfsset.sh

APPNAME=sendmail
VER=8.14.7
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$APPNAME.$VER.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	openldap
. $WRK/_checkOptions.sh  \
	openssl cyrus-sasl procmail \
        nph ghostscript
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

#echo Patching unofficial...
#patch -Np1 -i $WRK/patch/sendmail-$VER.patch \
#	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

groupadd -g 26 smmsp
useradd -c "Sendmail Daemon" -g smmsp -d /dev/null \
        -s /bin/false -u 26 smmsp 
chmod -v 1777 /var/mail 
install -v -m700 -d /var/spool/mqueue

#APPENDDEF(`confENVDEF',`-DSTARTTLS -DTCPWRAPPERS -DSASL -DLDAPMAP')
cat >> devtools/Site/site.config.m4 << "EOF"
APPENDDEF(`confENVDEF',`-DSTARTTLS -DSASL -DLDAPMAP')
APPENDDEF(`confLIBS', `-lssl -lcrypto -lsasl2 -lldap -llber')
APPENDDEF(`confINCDIRS', `-I/usr/include/sasl')
EOF

cat >> devtools/Site/site.config.m4 << "EOF"
define(`confMANGRP',`root')
define(`confMANOWN',`root')
define(`confSBINGRP',`root')
define(`confUBINGRP',`root')
define(`confUBINOWN',`root')
EOF

sed -i -r "s/^# if (DB.*)$/# if (\1) || DB_VERSION_MAJOR >= 5/" \
    include/sm/bdb.h

cd sendmail 

Making
sh Build \
	1> $LOG/$TARGET.1_make.log 2>&1 || exit 1

cd ../cf/cf 
cp generic-linux.mc sendmail.mc 
sh Build sendmail.cf \
	1>> $LOG/$TARGET.1_make.log 2>&1 || exit 1

install -v -d -m755 /etc/mail 
sh Build install-cf \
	1>> $LOG/$TARGET.1_make.log 2>&1 || exit 1

cd ../.. 

Installing
paco -p $TARGET "sh Build install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 cf/cf/{submit,sendmail}.mc /etc/mail" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
cp -v -R cf/* /etc/mail" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -v -m755 -d /usr/share/doc/sendmail-$VER/{cf,sendmail} 
paco -p+ $TARGET "\
install -v -m644 \
        CACerts FAQ KNOWNBUGS LICENSE PGPKEYS README RELEASE_NOTES \
        /usr/share/doc/sendmail-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 sendmail/{README,SECURITY,TRACEFLAGS,TUNING} \
        /usr/share/doc/sendmail-$VER/sendmail" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

paco -p+ $TARGET "\
install -v -m644 cf/README /usr/share/doc/sendmail-$VER/cf" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

for manpage in sendmail editmap mailstats makemap praliases smrsh
do
    paco -p+ $TARGET "install -v -m444 $manpage/$manpage.8 /usr/share/man/man8" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
done

paco -p+ $TARGET "install -v -m444 sendmail/aliases.5    /usr/share/man/man5" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "install -v -m444 sendmail/mailq.1      /usr/share/man/man1" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "install -v -m444 sendmail/newaliases.1 /usr/share/man/man1" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
paco -p+ $TARGET "install -v -m444 vacation/vacation.1   /usr/share/man/man1" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cd doc/op
sed -i 's/groff/GROFF_NO_SGR=1 groff/' Makefile 
#make op.txt op.pdf
make op.txt \
	1>> $LOG/$TARGET.2_make.log 2>&1 || exit 1

paco -p+ $TARGET "install -v -d -m755 /usr/share/doc/sendmail-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#install -v -m644 op.ps op.txt op.pdf /usr/share/doc/sendmail-$VER
paco -p+ $TARGET "install -v -m644 op.ps op.txt /usr/share/doc/sendmail-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cd ../..

echo $(hostname) > /etc/mail/local-host-names
cat > /etc/mail/aliases << "EOF"
postmaster: root
MAILER-DAEMON: root

EOF
newaliases -v

pushd /etc/mail
paco -p+ $TARGET "m4 m4/cf.m4 sendmail.mc > sendmail.cf" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
popd

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

